/* API.H
   Updated @ Date 7 December 1998, 9:5 by Gerrit van Niekerk
   API definitions
*/

#ifndef __WIN_TYPES
#define __WIN_TYPES
typedef unsigned char BYTE;
typedef unsigned int WORD;
typedef unsigned long DWORD;
#endif

#define API_INT		0x7f

#define API_NOOP			0	/* just keep INET alive */
#define API_SENDPING		1	/* send an ICMP echo request */
#define API_GETPING		2	/* get an ICMP echo request */
#define API_STARTMAIL	3	/* start the mail sender (client) */
#define API_GETIPADR		4	/* get an IP address, given a name */
#define API_TCPOPEN		5	/* open a TCP connection */
#define API_TCPREAD		6	/* read from a TCP connection */
#define API_TCPWRITE		7	/* write to a TCP connection */
#define API_TCPCLOSE		8	/* close a TCP connection */
#define API_TCPRESET		9	/* reset a TCP connection */
#define API_TCPDELET		10	/* delete TCP connection resources */
#define API_UDPOPEN		11	/* open a udp socket to receive dg's */
#define API_UDPREAD		12	/* read a udp datagram */
#define API_UDPWRITE		13	/* write a udp datagram */
#define API_UDPCLOSE		14	/* close a udp socket */
#define API_GETVARPTR	15	/* get pointer to variables */
#define API_GETKEY		16	/* get key from INET */
#define API_FILTER		17	// modify source route filter
#define API_TIMERCREATE	18	// create a timer
#define API_TIMERSET    19	// set a timer
#define API_TIMERSTART	20	// start a timer
#define API_TIMERSTOP	21	// stop a timer
#define API_TIMERDELETE	22	// delete a timer

/* Error return code */
#define NONE			0	/* No error */
#define CON_EXISTS	1	/* Connection already exists */
#define NO_CONN		2	/* Connection does not exist */
#define CON_CLOS		3	/* Connection closing */
#define NO_SPACE		4	/* No memory for TCB creation */
#define WOULDBLK		5	/* Would block */
#define NOPROTO		6	/* Protocol or mode not supported */
#define INVALID		7	/* Invalid arguments */
#define BUFSHORT		8	/* Buffer too short for data */
#define RE_ENTER		27	/* Re-entry of Inet */
#define NO_API		50	// API not loaded

/* Mode for the API_TCPOPEN call */
#define	TCP_PASSIVE	0
#define	TCP_ACTIVE	1
#define	TCP_SERVER	2	/* Passive, clone on opening */

/* Socket structure */
#ifndef SOCKET_DEF
#define SOCKET_DEF
typedef struct socket {
	DWORD dwAddress;		/* IP address */
	WORD wPort;				/* port number */
} SOCKET;

/* Connection structure (two sockets) */
typedef struct connection {
	SOCKET sLocal;
	SOCKET sRemote;
} CONNECTION;
#endif

#ifndef TIMER_DEF
#define TIMER_DEF
typedef struct timer {
	struct timer __near *next;
	struct timer __near *prev;
	unsigned long start;	/* Period of counter (load value) */
	unsigned long count;	/* Ticks to go until expiration */
	void (far *func)();		/* Function to call at expiration */
	char __near *arg;			/* Arg to pass function */
	char state;				/* Timer state */
} TIMER;
#endif
typedef struct timerl {
	struct timer far *next;
	struct timer far *prev;
	unsigned long start;	/* Period of counter (load value) */
	unsigned long count;	/* Ticks to go until expiration */
	void (far *func)();		/* Function to call at expiration */
	char far *arg;			/* Arg to pass function */
	char state;				/* Timer state */
} TIMERL;

/* IP statistics */
#ifndef IP_STAT_DEF
#define IP_STAT_DEF
struct ip_stats {
	long total;				/* Total packets received */
	unsigned runt;			/* Smaller than minimum size */
	unsigned length;		/* IP header length field too small */
	unsigned version;		/* Wrong IP version */
	unsigned checksum;		/* IP header checksum errors */
	unsigned badproto;		/* Unsupported protocol */
};
#endif

/* TCP statistics and status variables */
#define	NTCB	19
#ifndef TCP_STAT_DEF
#define TCP_STAT_DEF
struct tcp_stat {
	unsigned runt;		/* Smaller than minimum size */
	unsigned checksum;	/* TCP header checksum errors */
	unsigned conout;	/* Outgoing connection attempts */
	unsigned conin;		/* Incoming connection attempts */
	unsigned resets;	/* Resets generated */
	unsigned bdcsts;	/* Broadcast packets received */
	unsigned tcp_window;/* TCP Maximum offered window */
	unsigned tcp_mss;	/* Maximum segment size to be sent with SYN */
	unsigned tcp_irtt;	/* Initial guess at round trip time */
	unsigned tcp_retry;	/* maximum transmission retries */
	unsigned tel_tos;	/* TOS used by Telnet */
	char flush_flag;	/* To override Nagle */
	struct tcb __near *tcbs[NTCB];
};
struct tcp_statl {
	unsigned runt;		/* Smaller than minimum size */
	unsigned checksum;	/* TCP header checksum errors */
	unsigned conout;	/* Outgoing connection attempts */
	unsigned conin;		/* Incoming connection attempts */
	unsigned resets;	/* Resets generated */
	unsigned bdcsts;	/* Broadcast packets received */
	unsigned tcp_window;/* TCP Maximum offered window */
	unsigned tcp_mss;	/* Maximum segment size to be sent with SYN */
	unsigned tcp_irtt;	/* Initial guess at round trip time */
	unsigned tcp_retry;	/* maximum transmission retries */
	unsigned tel_tos;	/* TOS used by Telnet */
	char flush_flag;	/* To override Nagle */
	struct tcb far *tcbs[NTCB];
};
#endif

struct mem_stat {
	unsigned long mem_avail;	/* updated by API_GETVARP call */
	unsigned mem_fail;			/* number of memory alloc failures */
	int stack_avail;			/* lowest stack available observed */
	unsigned mem_free_err;		// memory release errors
};

/* the Line printer client is only implemented for RINET !! */
typedef struct {		/* line printer client control block */
	SOCKET fsocket;
	TIMER timer;
	struct tcb __near *tcb;
	void __near *buf;
	char status;
} LPCB;

typedef struct {
	struct ip_stats __near *ipstat;
	struct tcp_stat __near *tcpstat;
	struct mem_stat __near *memstat;
	LPCB __near *lpcb;
	void __near *ndesc;
	void __near *gdesc;
	int nndesc;		// number of network descriptors (local)
	int ngdesc;		// number of global network descriptors
	DWORD http_addr;// HTTP server address (set by BOOTP/DHCP)
} VARBLOCK;

typedef struct {
	struct ip_stats far *ipstat;
	struct tcp_stat far *tcpstat;
	struct mem_stat far *memstat;
	LPCB far *lpcb;
	void far *ndesc;
	void far *gdesc;
	int nndesc;		// number of network descriptors (local)
	int ngdesc;		// number of global network descriptors
	DWORD http_addr;// HTTP server address (set by BOOTP/DHCP)
} VARBLOCKL;

/* TCP port numbers */
#define	ECHO_PORT		7	/* Echo data port */
#define	DISCARD_PORT	9	/* Discard data port */
#define	FTPD_PORT		20	/* FTP Data port */
#define	FTP_PORT			21	/* FTP Control port */
#define 	TELNET_PORT		23	/* Telnet port */
#define 	SMTP_PORT		25	/* Mail port */

typedef struct {			/* UDP write parameter block */
	DWORD	dwRemIPAd;		/* remote IP address */
	WORD	wRemPort;			/* remote port */
	WORD	wLength;			/* data count */
	char far *lpBuf;		/* data buffer address */
} UDP_WR_P;

#ifndef TCB_DEF
#define TCB_DEF
typedef struct tcb {		/* TCP Control Block */
	struct tcb __near *prev;
	struct tcb __near *next;

	CONNECTION conn;

	char state;			/* Connection state */
#define	CLOSED			0
#define	LISTEN			1
#define	SYN_SENT		2
#define	SYN_RECEIVED	3
#define	ESTABLISHED		4
#define	FINWAIT1		5
#define	FINWAIT2		6
#define	CLOSE_WAIT		7
#define	CLOSING			8
#define	LAST_ACK		9
#define	TIME_WAIT		10

	char reason;		/* Reason for closing */
#define	R_NORMAL	0	/* Normal close */
#define	R_RESET		1	/* Reset by other end */
#define	R_TIMEOUT	2	/* Excessive retransmissions */
#define	R_NETWORK	3	/* Network problem (ICMP message) */

	/* If reason == NETWORK, the ICMP type and code values are stored here */
	char type;
	char code;

	/* Send sequence variables */
	struct {
		long una;	/* First unacknowledged sequence number */
		long nxt;	/* Next sequence num to be sent for the first time */
		long ptr;	/* Working transmission pointer */
		unsigned wnd;	/* Other end's offered receive window */
		long up;	/* Send urgent pointer */
		long wl1;	/* Sequence number used for last window update */
		long wl2;	/* Ack number used for last window update */
	} snd;
	long iss;		/* Initial send sequence number */
	unsigned cwind;		/* Congestion window */
	unsigned ssthresh;	/* Slow-start threshold */
	long resent;		/* Count of bytes retransmitted */

	/* Receive sequence variables */
	struct {
		long nxt;	/* Incoming sequence number expected next */
		unsigned wnd;	/* Our offered receive window */
		long up;	/* Receive urgent pointer */
	} rcv;
	long irs;		/* Initial receive sequence number */
	unsigned mss;		/* Maximum segment size */
	long rerecv;		/* Count of duplicate bytes received */

	unsigned window;	/* Receiver window and send queue limit */

	char backoff;		/* Backoff interval */
	char retry;		/* retry count */
	void (far *r_upcall)();	/* Call when "significant" amount of data arrives */
	void (far *t_upcall)();	/* Call when ok to send more data */
	void (far *s_upcall)();	/* Call when connection state changes */
	char flags;		/* Control flags */
#define	FORCE		1	/* We owe the other end an ACK or window update */
#define	CLONE		2	/* Server-type TCB, cloned on incoming SYN */
#define	RETRAN		4	/* A retransmission has occurred */
#define	TCP_RCV		8	/* Set on data arrival, reset by user */
#define	TCP_XMT		0x10	/* Set when ok to send more, reset by user */
#define	TCP_STC		0x20	/* Set on state change, reset by user */
#define	SEND_URG	0x40	/* Set when sending urgent data */
#define	RECV_URG	0x80	/* Set when receiving urgent data */
	char tos;		/* Type of service (for IP) */

	void __near *rcvq;	/* Receive queue */
	unsigned rcvcnt;

	void __near *sndq;	/* Send queue */
	unsigned sndcnt;	/* Number of unacknowledged sequence numbers on
				 * send queue. NB: includes SYN and FIN, which don't
				 * actually appear on sndq!
				 */


	void __near *reseq;	/* Out-of-order segment queue */
	TIMER timer;		/* Retransmission timer */
	TIMER rtt_timer;	/* Round trip timer */
	long rttseq;		/* Sequence number being timed */
	long srtt;		/* Smoothed round trip time, milliseconds */
	long mdev;		/* Mean deviation, milliseconds */

	void __near *user;	/* User parameter (e.g., for mapping to an
				 * application control block
				 */
} TCB;

typedef struct tcbl {		/* TCP Control Block */
	struct tcb far *prev;
	struct tcb far *next;

	CONNECTION conn;

	char state;		/* Connection state */
	char reason;		/* Reason for closing */
	char type;
	char code;

	/* Send sequence variables */
	struct {
		long una;	/* First unacknowledged sequence number */
		long nxt;	/* Next sequence num to be sent for the first time */
		long ptr;	/* Working transmission pointer */
		unsigned wnd;	/* Other end's offered receive window */
		long up;	/* Send urgent pointer */
		long wl1;	/* Sequence number used for last window update */
		long wl2;	/* Ack number used for last window update */
	} snd;
	long iss;		/* Initial send sequence number */
	unsigned cwind;		/* Congestion window */
	unsigned ssthresh;	/* Slow-start threshold */
	long resent;		/* Count of bytes retransmitted */

	/* Receive sequence variables */
	struct {
		long nxt;	/* Incoming sequence number expected next */
		unsigned wnd;	/* Our offered receive window */
		long up;	/* Receive urgent pointer */
	} rcv;
	long irs;		/* Initial receive sequence number */
	unsigned mss;		/* Maximum segment size */
	long rerecv;		/* Count of duplicate bytes received */

	unsigned window;	/* Receiver window and send queue limit */

	char backoff;		/* Backoff interval */
	char retry;		/* retry count */
	void (far *r_upcall)();	/* Call when "significant" amount of data arrives */
	void (far *t_upcall)();	/* Call when ok to send more data */
	void (far *s_upcall)();	/* Call when connection state changes */
	char flags;		/* Control flags */
	char tos;		/* Type of service (for IP) */

	void far *rcvq;	/* Receive queue */
	unsigned rcvcnt;

	void far *sndq;		/* Send queue */
	unsigned sndcnt;	/* Number of unacknowledged sequence numbers on
						 * send queue. NB: includes SYN and FIN, which don't
						 * actually appear on sndq!
						*/

	void far *reseq;	/* Out-of-order segment queue */
	TIMERL timer;		/* Retransmission timer */
	TIMERL rtt_timer;	/* Round trip timer */
	long rttseq;		/* Sequence number being timed */
	long srtt;		/* Smoothed round trip time, milliseconds */
	long mdev;		/* Mean deviation, milliseconds */

	void far *user;	/* User parameter (e.g., for mapping to an
				 * application control block
				 */
} TCBL;
#endif

typedef struct {		/* TCP open parameter block */
	DWORD dwRemIPAd;	/* remote IP address (0 for server) */
	WORD	wRemPort;	/* remote port (0 for server) */
	WORD	wLocPort;	/* local port (0 for auto assign, set by kernel) */
	WORD	wMode;		/* active/passive/server */
	WORD	wWindow;		/* window size (0 for default) */
	/* data receive upcall handler (0 for none) */
	void (far *pRcvUpcall)(struct tcb __near *psTcb,WORD wCnt);
	/* data send upcall handler (0 for none) */
	void (far *pSndUpcall)(struct tcb __near *psTcb,WORD wCnt);
	/* state change upcall handler (0 for none) */
	void (far *pStcUpcall)(struct tcb __near *psTcb,char cOldState,char cNewState);
	void __near *pUser;	/* user id field in TCB */
	char cTos;			/* type of service to use (normally 0) */
} TCP_OP_P;

// Filter functions
#define	FILTER_DISABLE	0
#define	FILTER_ENABLE	1
#define	FILTER_FLUSH   2
#define	FILTER_ADD     3
#define	FILTER_DROP    4

// Prototypes for API.C interface
// This is work in progress

DWORD GetIPAddress(char *pszName);
int TcpOpen(TCP_OP_P *pOp,WORD *pwHandle);
int TcpRead(WORD wHandle,char *pcBuf,int iLen);
int TcpWrite(WORD wHandle,char *pcBuf,int iLen,int iUrgent);
int TcpClose(WORD wHandle);
int TcpReset(WORD wHandle);
int TcpDelete(WORD wHandle);
char *NetErrStr(int iErrCode);

/* API documentation:
The API is called by calling interrupt API_INT with AH = function code
Other registers are set up and/or returned as detailed below:

SENDPING:
 Entry:
	AH:	API_SENDPING
	BX:	Sequence number
	CX,DX:	IP address
 Exit:
	No change

GETPING:
 Entry:
	AH:	API_GETPING
 Exit:
	AH:	== 0 -> no response
		!= 0 -> valid response
	BX:	Sequence number
	CX,DX:	IP address

STARTMAIL:
 Entry:
	AH:	API_STARTMAIL
 Exit:
	No change

GETIPADR:
 Entry:
	AH:	API_GETIPADR
	BX:CX:	Pointer to name
	If BX:CX == 0:0 then return local IP address and hostname
 Exit:
	CX,DX:	IP address (0 if not found)
	BX:SI:	Pointer to hostname (if BX:CX == 0:0)

TCPOPEN:		open a TCP connection
 Entry:
	AH:	API_TCPOPEN
	BX:CX:	Parameters address, SEG:OFF
 Exit:
	BX:CX:	TCB address, SEG:OFF default INET
	CX:BX:	TCB address, SEG:OFF Large Inet (BX == 4)
	AX:	Error

TCPREAD:		read from a TCP connection
 Entry:
	AH:	API_TCPREAD
	BX:	TCB address
	CX:	Count
	DX:SI	Buffer address (SEG:OFF)
 Exit:
	CX:	Actual read count
	AX:	Error

TCPWRITE:		write to a TCP connection
 Entry:
	AH:	API_TCPWRITE
	AL:	1 for urgent data
	BX:	TCB address
	CX:	Count
	DX:SI	Buffer address (SEG:OFF)

 Exit:
	CX:	Actual write count
	AX:	Error

TCPCLOSE:		close a TCP connection
TCPRESET:		reset a TCP connection
TCPDELET:		delete TCP connection resources
 Entry:
	AH:	API_TCPCLOSE, API_TCPRESET or API_TCPDELET
	BX:	TCB address

 Exit:
	AX:	Error

UDPOPEN:		open a udp socket to receive dg's
 Entry:
	AH:	API_UDPOPEN
	BX:	Local port number
	CX:DX:	Receive upcall address	(0000:0000 for none)
 Exit:
	AX:	Error

UDPREAD:		read a udp datagram
 Entry:
	AH:	API_UDPREAD
	BX:	Local port number
	CX:	Max count
	DX:SI	Buffer address (SEG:OFF)
 Exit:
	AX:	Error
	CX:	Actual read count
	BX:	Remote socket
	DX,SI:	Remote IP address

UDPWRITE:		write a udp datagram
 Entry:
	AH:	API_UDPWRITE
	BX:	Local port number
	DX:SI	Parameter address (SEG:OFF) (UDP_WR_P)
 Exit:
	AX:	Error

UDPCLOSE:		close a udp socket
 Entry:
	AH:	API_UDPCLOSE
	BX:	Local port number
 Exit:
	AX:	Error

GETVARPTR:		get pointer to variables
 Entry:
	AH:	API_GETVARPTR
 Exit:
	BX:CX:	variable block address, SEG:OFF (VARBLOCK)

GETKEY:			get a key from INET
 Entry:
	AH:	API_GETKEY
 Exit:
	AX:	key scancode or -1 if none
	BX:	shift status

FILTER:			modify source route filter to default route
 Entry:
	AH:	API_FILTER
	BX:	FILTER_DISABLE
		FILTER_ENABLE
		FILTER_FLUSH
		FILTER_ADD
	CX,DX	address to add to filter list
 Exit:	0	success
		-1	address already in filter list
		-2	not enough memory to add address
		FILTER_DROP
	CX,DX	address to drop from filter list
 Exit:	0	success
		-1	address not in filter list

TIMERCREATE:	create a timer
 Entry:
	AH:		API_TIMERCREATE
	BX:     Argument to pass to callback funtion
	CX:DX  	Timer period in milliseconds
 	SI:DI	Callback address, SEG:OFF
 Exit:
	BX:CX:	Timer address, SEG:OFF
	AX:		Error code: 0 OK, NO_SPACE if out of memory

TIMERSET:		set a timer
 Entry:
	AH:		API_TIMERSET
	BX:		Timer address offset
	CX:DX	Timer period in milliseconds
 Exit:
	AX:		Error code: 0 OK

TIMERSTART		start a timer
 Entry:
	AH:		API_TIMERSTART
	BX:		Timer address offset
 Exit:
	AX:		Error code: 0 OK

TIMERSTOP		stop a timer
 Entry:
	AH:		API_TIMERSTOP
	BX:		Timer address offset
 Exit:
	AX:		Error code: 0 OK

TIMERDELETE		delete a timer, free memory used by timer
 Entry:
	AH:		API_TIMERDELETE
	BX:		Timer address offset
 Exit:
	AX:		Error code: 0 OK


                      TCP Connection State Diagram

                              +---------+ ---------\      active OPEN  
                              |  CLOSED |            \    -----------  
                              +---------+<---------\   \   create TCB  
                                |     ^              \   \  snd SYN    
                   passive OPEN |     |   CLOSE        \   \           
                   ------------ |     | ----------       \   \         
                    create TCB  |     | delete TCB         \   \       
                                V     |                      \   \     
                              +---------+            CLOSE    |    \   
                              |  LISTEN |          ---------- |     |  
                              +---------+          delete TCB |     |  
                   rcv SYN      |     |     SEND              |     |  
                  -----------   |     |    -------            |     V  
 +---------+      snd SYN,ACK  /       \   snd SYN          +---------+
 |         |<-----------------           ------------------>|         |
 |   SYN_  |                    rcv SYN                     |   SYN_  |
 |RECEIVED |<-----------------------------------------------|   SENT  |
 |         |                    snd ACK                     |         |
 |         |------------------           -------------------|         |
 +---------+   rcv ACK of SYN  \       /  rcv SYN,ACK       +---------+
   |           --------------   |     |   -----------                  
   |                  x         |     |     snd ACK                    
   |                            V     V                                
   |  CLOSE                 +-------------+                              
   | -------                | ESTABLISHED |                              
   | snd FIN                +-------------+                              
   |                   CLOSE    |     |    rcv FIN                     
   V                  -------   |     |    -------                     
 +---------+          snd FIN  /       \   snd ACK          +---------+
 |FINWAIT1 |<-----------------           ------------------>| CLOSE_  |
 |         |------------------                              |  WAIT   |
 +---------+          rcv FIN  \                            +---------+
   | rcv ACK of FIN   -------   |                            CLOSE  |  
   | --------------   snd ACK   |                           ------- |  
   V        x                   V                           snd FIN V  
 +---------+                  +---------+                   +---------+
 |FINWAIT2 |                  | CLOSING |                   | LAST_ACK|
 +---------+                  +---------+                   +---------+
   |                rcv ACK of FIN |                 rcv ACK of FIN |  
   |  rcv FIN       -------------- |    Timeout=2MSL -------------- |  
   |  -------              x       V    ------------        x       V  
    \ snd ACK                 +---------+ delete TCB        +---------+
     ------------------------>|TIME_WAIT|------------------>| CLOSED  |
                              +---------+                   +---------+
*/
